/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05;

import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class RemoteDomino {
	static String host = "www.djbuch.de",
		user = "Thomas Ekert/DJBUCH",
		pwd = "geheim";


	public static void main(String argv[]) {
		Session session=null;
		try {
			//Login as User
			session = NotesFactory.createSession(host, user, pwd);
			String p = session.getPlatform();
			printInfo(session);
			recycleSession(session);
			//Login without HTTP Task on Server
			session = NotesFactory.createSession ("127.0.0.1:63148", user, pwd);
			printInfo (session);
			recycleSession(session);
			// Login as anonymous User
			session = NotesFactory.createSession(host,"","");
			printInfo (session);
			recycleSession(session);
			// Login as anonymous User again
			session = NotesFactory.createSession(host);
			printInfo (session);
		} catch (NotesException e) {
			System.err.println ("Notes Error Number: " + e.id);
			e.printStackTrace();
		} finally {
			recycleSession(session);
		}
	}

	private static void printInfo(Session s)
		throws NotesException {
		System.out.println ("SessionClass\t= " + s.getClass().getName());
		System.out.println ("Platform\t\t= " + s.getPlatform());
		System.out.println ("Version\t\t\t= " + s.getNotesVersion());
		System.out.println ("User\t\t\t= " + s.getUserName());
		System.out.println ("Session Token\t= " + s.getSessionToken());
		System.out.println ("Servername\t\t= <<" + s.getServerName() + ">>\n");	
	}
	
	private static void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (NotesException e) {
			e.printStackTrace(); 
		}
	}
	
}